set VIVADO_VER=2013.4

REM If the XILINX_VIVADO env var is not set, or if it isn't set to the correct VIVADO_VER,
REM then go set it correctly before doing the rest of the batch tasks
if NOT "%XILINX_VIVADO%" == "C:\Xilinx\Vivado\%VIVADO_VER%" GOTO CHECK64
@ECHO The correct XILINX environment variable was detected.
GOTO DO_BATCH

:CHECK64
if NOT "%PROCESSOR_ARCHITECTURE%" == "AMD64" GOTO SET32
@ECHO The XILINX environment variable was not detected and this is a 64-bit PC.
@ECHO Setting 64-bit environment variables now...
call C:\Xilinx\Vivado\%VIVADO_VER%\settings64.bat
GOTO DO_BATCH

:SET32
@ECHO The XILINX environment variable was not detected and this is a 32-bit PC.
@ECHO Setting 32-bit environment variables now...
call C:\Xilinx\Vivado\%VIVADO_VER%\settings32.bat

:DO_BATCH
bootgen -image bootimage.bif -w -o i BOOT.BIN