-------------------------------------------------------------------------------
-- $Id:$
-------------------------------------------------------------------------------
-- coregen_comp_defs - entity/architecture pair
-------------------------------------------------------------------------------
--
-- *************************************************************************
-- **                                                                     **
-- ** DISCLAIMER OF LIABILITY                                             **
-- **                                                                     **
-- ** This text/file contains proprietary, confidential                   **
-- ** information of Xilinx, Inc., is distributed under                   **
-- ** license from Xilinx, Inc., and may be used, copied                  **
-- ** and/or disclosed only pursuant to the terms of a valid              **
-- ** license agreement with Xilinx, Inc. Xilinx hereby                   **
-- ** grants you a license to use this text/file solely for               **
-- ** design, simulation, implementation and creation of                  **
-- ** design files limited to Xilinx devices or technologies.             **
-- ** Use with non-Xilinx devices or technologies is expressly            **
-- ** prohibited and immediately terminates your license unless           **
-- ** covered by a separate agreement.                                    **
-- **                                                                     **
-- ** Xilinx is providing this design, code, or information               **
-- ** "as-is" solely for use in developing programs and                   **
-- ** solutions for Xilinx devices, with no obligation on the             **
-- ** part of Xilinx to provide support. By providing this design,        **
-- ** code, or information as one possible implementation of              **
-- ** this feature, application or standard, Xilinx is making no          **
-- ** representation that this implementation is free from any            **
-- ** claims of infringement. You are responsible for obtaining           **
-- ** any rights you may require for your implementation.                 **
-- ** Xilinx expressly disclaims any warranty whatsoever with             **
-- ** respect to the adequacy of the implementation, including            **
-- ** but not limited to any warranties or representations that this      **
-- ** implementation is free from claims of infringement, implied         **
-- ** warranties of merchantability or fitness for a particular           **
-- ** purpose.                                                            **
-- **                                                                     **
-- ** Xilinx products are not intended for use in life support            **
-- ** appliances, devices, or systems. Use in such applications is        **
-- ** expressly prohibited.                                               **
-- **                                                                     **
-- ** Any modifications that are made to the Source Code are              **
-- ** done at the users sole risk and will be unsupported.               **
-- ** The Xilinx Support Hotline does not have access to source           **
-- ** code and therefore cannot answer specific questions related         **
-- ** to source HDL. The Xilinx Hotline support of original source        **
-- ** code IP shall only address issues and questions related             **
-- ** to the standard Netlist version of the core (and thus               **
-- ** indirectly, the original core source).                              **
-- **                                                                     **
-- ** Copyright (c) 2008-2010 Xilinx, Inc. All rights reserved.           **
-- **                                                                     **
-- ** This copyright and support notice must be retained as part          **
-- ** of this text at all times.                                          **
-- **                                                                     **
-- *************************************************************************
--
-------------------------------------------------------------------------------
-- Filename:        coregen_comp_defs.vhd
-- Version:         initial
-- Description:     
--   Component declarations for all black box netlists generated by
--   running COREGEN and FIFO Generator when XST elaborated the client core
--
--
--
-- VHDL-Standard:   VHDL'93
-------------------------------------------------------------------------------
-- Structure:   
--                      -- coregen_comp_defs.vhd
--                          |
--                          |--- XilinxCoreLib.fifo_generator_v9_2
--                          |--- XilinxCoreLib.fifo_generator_v9_3
--                          |
--                          |--- XilinxCoreLib.blk_mem_gen_v7_1
--                          |--- XilinxCoreLib.blk_mem_gen_v7_3
--
-------------------------------------------------------------------------------
-- Author:          DET
-- History:
--   DET           02/01/2008    Initial Version
--
--     DET     2/01/2008     for proc_common_v4_0
-- ~~~~~~
--     - Adapted coregen_comp_defs.vhd from proc_common_v2_00_a to create 
--       this file.
--     - Changed instance of sync fifo to use new wrapper file that will adapt
--       to FIFO Generator primitive.
--     - Replaced "edk_generatecore" with "generatecore" utility call
--     - Removed the CAM component
-- ^^^^^^
--
--     DET     7/30/2008     for EDK 11.1
-- ~~~~~~
--     - Added component for Fifo Generator version 4.3
--     - Added Block Memory Generator Component Version 2.7
-- ^^^^^^
--
--     MSH     2/26/2009     for EDK 11.1
-- ~~~~~~
--     - Added component for Fifo Generator version 5.1
--     - Added Block Memory Generator Component Version 3.1
-- ^^^^^^
--
--     DET     3/2/2009     for EDK 11.1
-- ~~~~~~
--     - Added new Parameters and ports for Fifo Generatore 5.1.
-- ^^^^^^
--
--     DET     3/30/2009     EDK 11.2
-- ~~~~~~
--     - Had to reorder parameter list of FIFO Generator 4.3 component to match
--       the corresponding Verilog model due to NCSIM positional order
--       dependancy of parameters in vhdl/verilog use case.
-- ^^^^^^
--
--     DET     4/8/2009     EDK 11.2
-- ~~~~~~
--     - Added blk_mem_gen_v3_2
-- ^^^^^^
--
--     DET     4/9/2009     EDK 11.2
-- ~~~~~~
--     - Added fifo_generator_v5_2
-- ^^^^^^
--
--     DET     2/9/2010     For EDK 12.1
-- ~~~~~~
--     - Added fifo_generator_v5_3
--     - Added blk_mem_gen_v3_3
-- ^^^^^^
--
--     DET     3/10/2010     For EDK 12.x
-- ~~~~~~
--   -- Per CR553307
--     - Added fifo_generator_v6_1
--     - Added blk_mem_gen_v4_1
-- ^^^^^^
--
--     DET     3/17/2010     Initial
-- ~~~~~~
--    -- Per CR554253
--     - Incorporated changes to comment out FLOP_DELAY parameter from the 
--       blk_mem_gen_v4_1 component. This parameter is on the XilinxCoreLib
--       model for blk_mem_gen_v4_1 but is declared as a TIME type for the
--       vhdl version and an integer for the verilog. 
-- ^^^^^^
--
--     DET     10/04/2010     EDK 13.1
-- ~~~~~~
--     - Added fifo_generator_v7_3
--     - Added blk_mem_gen_v5_2
-- ^^^^^^
--
--     DET     12/8/2010     EDK 13.1
-- ~~~~~~
--    -- Per CR586109
--     - Replaced fifo_generator v7.3 with v8.1
--     - Added blk_mem_gen_v6_1
-- ^^^^^^
--
--     DET     12/17/2010     EDK 13.1
-- ~~~~~~
--    -- Per CR587494
--     - Removed blk_mem_gen v6_1
-- ^^^^^^
--
--     DET     3/2/2011     EDK 13.2
-- ~~~~~~
--    -- Per CR595473
--     - Update to use fifo_generator_v8_2
--     - Update to use blk_mem_gen_v6_2
--     - Remove out of date components.
-- ^^^^^^
--
--     DET     3/3/2011     EDK 13.2
-- ~~~~~~
--     - Removed C_ELABORATION_DIR parameter from the component decalarion
-- ^^^^^^
--
--     DET     3/7/2011     EDK 13.2
-- ~~~~~~
--    -- Per CR596052
--     - Added removed fifo generator and Blk Mem Gen components back into
--       coregen_comp_defs.  
-- ^^^^^^
--
--     RBODDU  08/18/2011     EDK 13.3
-- ~~~~~~
--     - Update to use fifo_generator_v8_3
-- ^^^^^^
--
-------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;

library fifo_generator_v11_0;
use fifo_generator_v11_0.all;

library blk_mem_gen_v8_1;
use blk_mem_gen_v8_1.all;

PACKAGE coregen_comp_defs IS

 
 
 
--------------------------------------------------------  
-- Declare general attributes used in this file
-- for defining each component being used with 
-- the generatecore utility

attribute box_type: string;
attribute GENERATOR_DEFAULT: string;

-------------------------------------------------------


-------------------------------------------------------------------------------------
-- Start FIFO Generator Component for fifo_generator_v11_0
-- The Component declaration for fifo_generator_v11_0 pulled from the 
-- Coregen version of 
-- file: fifo_generator_v11_0_comp.vhd. 
--
-- This component is used for both dual clock (async) and synchronous fifos 
-- implemented with BRAM or distributed RAM. Hard FIFO simulation support may not
-- be provided in FIFO Generator V10.0 so not supported here.
--
-- Note: AXI ports and parameters added for this version of FIFO Generator.
--
-------------------------------------------------------------------------------------
COMPONENT fifo_generator_v11_0 
  GENERIC (
    -------------------------------------------------------------------------
    -- Generic Declarations
    -------------------------------------------------------------------------
    C_COMMON_CLOCK                          : integer := 0;
    C_COUNT_TYPE                            : integer := 0;
    C_DATA_COUNT_WIDTH                      : integer := 2;
    C_DEFAULT_VALUE                         : string  := "";
    C_DIN_WIDTH                             : integer := 8;
    C_DOUT_RST_VAL                          : string  := "";
    C_DOUT_WIDTH                            : integer := 8;
    C_ENABLE_RLOCS                          : integer := 0;
    C_FAMILY                                : string  := "virtex6";
    C_FULL_FLAGS_RST_VAL                    : integer := 1;
    C_HAS_ALMOST_EMPTY                      : integer := 0;
    C_HAS_ALMOST_FULL                       : integer := 0;
    C_HAS_BACKUP                            : integer := 0;
    C_HAS_DATA_COUNT                        : integer := 0;
    C_HAS_INT_CLK                           : integer := 0;
    C_HAS_MEMINIT_FILE                      : integer := 0;
    C_HAS_OVERFLOW                          : integer := 0;
    C_HAS_RD_DATA_COUNT                     : integer := 0;
    C_HAS_RD_RST                            : integer := 0;
    C_HAS_RST                               : integer := 1;
    C_HAS_SRST                              : integer := 0;
    C_HAS_UNDERFLOW                         : integer := 0;
    C_HAS_VALID                             : integer := 0;
    C_HAS_WR_ACK                            : integer := 0;
    C_HAS_WR_DATA_COUNT                     : integer := 0;
    C_HAS_WR_RST                            : integer := 0;
    C_IMPLEMENTATION_TYPE                   : integer := 0;
    C_INIT_WR_PNTR_VAL                      : integer := 0;
    C_MEMORY_TYPE                           : integer := 1;
    C_MIF_FILE_NAME                         : string  := "";
    C_OPTIMIZATION_MODE                     : integer := 0;
    C_OVERFLOW_LOW                          : integer := 0;
    C_PRELOAD_LATENCY                       : integer := 1;
    C_PRELOAD_REGS                          : integer := 0;
    C_PRIM_FIFO_TYPE                        : string  := "4kx4";
    C_PROG_EMPTY_THRESH_ASSERT_VAL          : integer := 0;
    C_PROG_EMPTY_THRESH_NEGATE_VAL          : integer := 0;
    C_PROG_EMPTY_TYPE                       : integer := 0;
    C_PROG_FULL_THRESH_ASSERT_VAL           : integer := 0;
    C_PROG_FULL_THRESH_NEGATE_VAL           : integer := 0;
    C_PROG_FULL_TYPE                        : integer := 0;
    C_RD_DATA_COUNT_WIDTH                   : integer := 2;
    C_RD_DEPTH                              : integer := 256;
    C_RD_FREQ                               : integer := 1;
    C_RD_PNTR_WIDTH                         : integer := 8;
    C_UNDERFLOW_LOW                         : integer := 0;
    C_USE_DOUT_RST                          : integer := 0;
    C_USE_ECC                               : integer := 0;
    C_USE_EMBEDDED_REG                      : integer := 0;
    C_USE_FIFO16_FLAGS                      : integer := 0;
    C_USE_FWFT_DATA_COUNT                   : integer := 0;
    C_VALID_LOW                             : integer := 0;
    C_WR_ACK_LOW                            : integer := 0;
    C_WR_DATA_COUNT_WIDTH                   : integer := 2;
    C_WR_DEPTH                              : integer := 256;
    C_WR_FREQ                               : integer := 1;
    C_WR_PNTR_WIDTH                         : integer := 8;
    C_WR_RESPONSE_LATENCY                   : integer := 1;
    C_MSGON_VAL                             : integer := 1;
    C_ENABLE_RST_SYNC                       : integer := 1;
    C_ERROR_INJECTION_TYPE                  : integer := 0;
    C_SYNCHRONIZER_STAGE                    : integer := 2;

    -- AXI Interface related parameters start here
    C_INTERFACE_TYPE                        : integer := 0; -- 0: Native Interface; 1: AXI4 Stream; 2: AXI4/AXI3
    C_AXI_TYPE                              : integer := 0; -- 1: AXI4; 2: AXI4 Lite; 3: AXI3
    C_HAS_AXI_WR_CHANNEL                    : integer := 0;
    C_HAS_AXI_RD_CHANNEL                    : integer := 0;
    C_HAS_SLAVE_CE                          : integer := 0;
    C_HAS_MASTER_CE                         : integer := 0;
    C_ADD_NGC_CONSTRAINT                    : integer := 0;
    C_USE_COMMON_OVERFLOW                   : integer := 0;
    C_USE_COMMON_UNDERFLOW                  : integer := 0;
    C_USE_DEFAULT_SETTINGS                  : integer := 0;

    -- AXI Full/Lite
    C_AXI_ID_WIDTH                          : integer := 4;
    C_AXI_ADDR_WIDTH                        : integer := 32;
    C_AXI_DATA_WIDTH                        : integer := 64;
    C_AXI_LEN_WIDTH                         : integer := 8;
    C_AXI_LOCK_WIDTH                        : integer := 2;
    C_HAS_AXI_ID                            : integer := 0;
    C_HAS_AXI_AWUSER                        : integer := 0;
    C_HAS_AXI_WUSER                         : integer := 0;
    C_HAS_AXI_BUSER                         : integer := 0;
    C_HAS_AXI_ARUSER                        : integer := 0;
    C_HAS_AXI_RUSER                         : integer := 0;
    C_AXI_ARUSER_WIDTH                      : integer := 1;
    C_AXI_AWUSER_WIDTH                      : integer := 1;
    C_AXI_WUSER_WIDTH                       : integer := 1;
    C_AXI_BUSER_WIDTH                       : integer := 1;
    C_AXI_RUSER_WIDTH                       : integer := 1;
                                       
    -- AXI Streaming
    C_HAS_AXIS_TDATA                        : integer := 0;
    C_HAS_AXIS_TID                          : integer := 0;
    C_HAS_AXIS_TDEST                        : integer := 0;
    C_HAS_AXIS_TUSER                        : integer := 0;
    C_HAS_AXIS_TREADY                       : integer := 1;
    C_HAS_AXIS_TLAST                        : integer := 0;
    C_HAS_AXIS_TSTRB                        : integer := 0;
    C_HAS_AXIS_TKEEP                        : integer := 0;
    C_AXIS_TDATA_WIDTH                      : integer := 64;
    C_AXIS_TID_WIDTH                        : integer := 8;
    C_AXIS_TDEST_WIDTH                      : integer := 4;
    C_AXIS_TUSER_WIDTH                      : integer := 4;
    C_AXIS_TSTRB_WIDTH                      : integer := 4;
    C_AXIS_TKEEP_WIDTH                      : integer := 4;

    -- AXI Channel Type
    -- WACH --> Write Address Channel
    -- WDCH --> Write Data Channel
    -- WRCH --> Write Response Channel
    -- RACH --> Read Address Channel
    -- RDCH --> Read Data Channel
    -- AXIS --> AXI Streaming
    C_WACH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logic
    C_WDCH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie
    C_WRCH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie
    C_RACH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie
    C_RDCH_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie
    C_AXIS_TYPE                             : integer := 0; -- 0 = FIFO; 1 = Register Slice; 2 = Pass Through Logie

    -- AXI Implementation Type
    -- 1 = Common Clock Block RAM FIFO
    -- 2 = Common Clock Distributed RAM FIFO
    -- 5 = Common Clock Built-in FIFO
    -- 11 = Independent Clock Block RAM FIFO
    -- 12 = Independent Clock Distributed RAM FIFO
    C_IMPLEMENTATION_TYPE_WACH              : integer := 1;
    C_IMPLEMENTATION_TYPE_WDCH              : integer := 1;
    C_IMPLEMENTATION_TYPE_WRCH              : integer := 1;
    C_IMPLEMENTATION_TYPE_RACH              : integer := 1;
    C_IMPLEMENTATION_TYPE_RDCH              : integer := 1;
    C_IMPLEMENTATION_TYPE_AXIS              : integer := 1;

    -- AXI FIFO Type
    -- 0 = Data FIFO
    -- 1 = Packet FIFO
    -- 2 = Low Latency Sync FIFO
    -- 3 = Low Latency Async FIFO
    C_APPLICATION_TYPE_WACH                 : integer := 0;
    C_APPLICATION_TYPE_WDCH                 : integer := 0;
    C_APPLICATION_TYPE_WRCH                 : integer := 0;
    C_APPLICATION_TYPE_RACH                 : integer := 0;
    C_APPLICATION_TYPE_RDCH                 : integer := 0;
    C_APPLICATION_TYPE_AXIS                 : integer := 0;

    -- Enable ECC
    -- 0 = ECC disabled
    -- 1 = ECC enabled
    C_USE_ECC_WACH                          : integer := 0;
    C_USE_ECC_WDCH                          : integer := 0;
    C_USE_ECC_WRCH                          : integer := 0;
    C_USE_ECC_RACH                          : integer := 0;
    C_USE_ECC_RDCH                          : integer := 0;
    C_USE_ECC_AXIS                          : integer := 0;

    -- ECC Error Injection Type
    -- 0 = No Error Injection
    -- 1 = Single Bit Error Injection
    -- 2 = Double Bit Error Injection
    -- 3 = Single Bit and Double Bit Error Injection
    C_ERROR_INJECTION_TYPE_WACH             : integer := 0;
    C_ERROR_INJECTION_TYPE_WDCH             : integer := 0;
    C_ERROR_INJECTION_TYPE_WRCH             : integer := 0;
    C_ERROR_INJECTION_TYPE_RACH             : integer := 0;
    C_ERROR_INJECTION_TYPE_RDCH             : integer := 0;
    C_ERROR_INJECTION_TYPE_AXIS             : integer := 0;

    -- Input Data Width
    -- Accumulation of all AXI input signal's width
    C_DIN_WIDTH_WACH                        : integer := 32;
    C_DIN_WIDTH_WDCH                        : integer := 64;
    C_DIN_WIDTH_WRCH                        : integer := 2;
    C_DIN_WIDTH_RACH                        : integer := 32;
    C_DIN_WIDTH_RDCH                        : integer := 64;
    C_DIN_WIDTH_AXIS                        : integer := 1;

    C_WR_DEPTH_WACH                         : integer := 16;
    C_WR_DEPTH_WDCH                         : integer := 1024;
    C_WR_DEPTH_WRCH                         : integer := 16;
    C_WR_DEPTH_RACH                         : integer := 16;
    C_WR_DEPTH_RDCH                         : integer := 1024;
    C_WR_DEPTH_AXIS                         : integer := 1024;

    C_WR_PNTR_WIDTH_WACH                    : integer := 4;
    C_WR_PNTR_WIDTH_WDCH                    : integer := 10;
    C_WR_PNTR_WIDTH_WRCH                    : integer := 4;
    C_WR_PNTR_WIDTH_RACH                    : integer := 4;
    C_WR_PNTR_WIDTH_RDCH                    : integer := 10;
    C_WR_PNTR_WIDTH_AXIS                    : integer := 10;

    C_HAS_DATA_COUNTS_WACH                  : integer := 0;
    C_HAS_DATA_COUNTS_WDCH                  : integer := 0;
    C_HAS_DATA_COUNTS_WRCH                  : integer := 0;
    C_HAS_DATA_COUNTS_RACH                  : integer := 0;
    C_HAS_DATA_COUNTS_RDCH                  : integer := 0;
    C_HAS_DATA_COUNTS_AXIS                  : integer := 0;

    C_HAS_PROG_FLAGS_WACH                   : integer := 0;
    C_HAS_PROG_FLAGS_WDCH                   : integer := 0;
    C_HAS_PROG_FLAGS_WRCH                   : integer := 0;
    C_HAS_PROG_FLAGS_RACH                   : integer := 0;
    C_HAS_PROG_FLAGS_RDCH                   : integer := 0;
    C_HAS_PROG_FLAGS_AXIS                   : integer := 0;

    -- 0: No Programmable FULL
    -- 1: Single Programmable FULL Threshold Constant
    -- 3: Single Programmable FULL Threshold Input Port
    C_PROG_FULL_TYPE_WACH                   : integer := 5;
    C_PROG_FULL_TYPE_WDCH                   : integer := 5;
    C_PROG_FULL_TYPE_WRCH                   : integer := 5;
    C_PROG_FULL_TYPE_RACH                   : integer := 5;
    C_PROG_FULL_TYPE_RDCH                   : integer := 5;
    C_PROG_FULL_TYPE_AXIS                   : integer := 5;

    -- Single Programmable FULL Threshold Constant Assert Value
    C_PROG_FULL_THRESH_ASSERT_VAL_WACH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_WDCH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_WRCH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_RACH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_RDCH      : integer := 1023;
    C_PROG_FULL_THRESH_ASSERT_VAL_AXIS      : integer := 1023;

    -- 0: No Programmable EMPTY
    -- 1: Single Programmable EMPTY Threshold Constant
    -- 3: Single Programmable EMPTY Threshold Input Port
    C_PROG_EMPTY_TYPE_WACH                  : integer := 5;
    C_PROG_EMPTY_TYPE_WDCH                  : integer := 5;
    C_PROG_EMPTY_TYPE_WRCH                  : integer := 5;
    C_PROG_EMPTY_TYPE_RACH                  : integer := 5;
    C_PROG_EMPTY_TYPE_RDCH                  : integer := 5;
    C_PROG_EMPTY_TYPE_AXIS                  : integer := 5;

    -- Single Programmable EMPTY Threshold Constant Assert Value
    C_PROG_EMPTY_THRESH_ASSERT_VAL_WACH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_WDCH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_WRCH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_RACH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_RDCH     : integer := 1022;
    C_PROG_EMPTY_THRESH_ASSERT_VAL_AXIS     : integer := 1022;

    C_REG_SLICE_MODE_WACH                   : integer := 0;
    C_REG_SLICE_MODE_WDCH                   : integer := 0;
    C_REG_SLICE_MODE_WRCH                   : integer := 0;
    C_REG_SLICE_MODE_RACH                   : integer := 0;
    C_REG_SLICE_MODE_RDCH                   : integer := 0;
    C_REG_SLICE_MODE_AXIS                   : integer := 0
    );


  PORT(
    ------------------------------------------------------------------------------
    -- Input and Output Declarations
    ------------------------------------------------------------------------------

    -- Conventional FIFO Interface Signals
    backup                         : in  std_logic := '0';
    backup_marker                  : in  std_logic := '0';
    clk                            : in  std_logic := '0';
    rst                            : in  std_logic := '0';
    srst                           : in  std_logic := '0';
    wr_clk                         : in  std_logic := '0';
    wr_rst                         : in  std_logic := '0';
    rd_clk                         : in  std_logic := '0';
    rd_rst                         : in  std_logic := '0';
    din                            : in  std_logic_vector(C_DIN_WIDTH-1 downto 0) := (others => '0');
    wr_en                          : in  std_logic := '0';
    rd_en                          : in  std_logic := '0';

    -- optional inputs
    prog_empty_thresh              : in  std_logic_vector(C_RD_PNTR_WIDTH-1 downto 0) := (others => '0');
    prog_empty_thresh_assert       : in  std_logic_vector(C_RD_PNTR_WIDTH-1 downto 0) := (others => '0');
    prog_empty_thresh_negate       : in  std_logic_vector(C_RD_PNTR_WIDTH-1 downto 0) := (others => '0');
    prog_full_thresh               : in  std_logic_vector(C_WR_PNTR_WIDTH-1 downto 0) := (others => '0');
    prog_full_thresh_assert        : in  std_logic_vector(C_WR_PNTR_WIDTH-1 downto 0) := (others => '0');
    prog_full_thresh_negate        : in  std_logic_vector(C_WR_PNTR_WIDTH-1 downto 0) := (others => '0');
    int_clk                        : in  std_logic := '0';
    injectdbiterr                  : in  std_logic := '0';
    injectsbiterr                  : in  std_logic := '0';

    dout                           : out std_logic_vector(C_DOUT_WIDTH-1 downto 0) := (others => '0');
    full                           : out std_logic := '0';
    almost_full                    : out std_logic := '0';
    wr_ack                         : out std_logic := '0';
    overflow                       : out std_logic := '0';
    empty                          : out std_logic := '1';
    almost_empty                   : out std_logic := '1';
    valid                          : out std_logic := '0';
    underflow                      : out std_logic := '0';
    data_count                     : out std_logic_vector(C_DATA_COUNT_WIDTH-1 downto 0) := (others => '0');
    rd_data_count                  : out std_logic_vector(C_RD_DATA_COUNT_WIDTH-1 downto 0) := (others => '0');
    wr_data_count                  : out std_logic_vector(C_WR_DATA_COUNT_WIDTH-1 downto 0) := (others => '0');
    prog_full                      : out std_logic := '0';
    prog_empty                     : out std_logic := '1';
    sbiterr                        : out std_logic := '0';
    dbiterr                        : out std_logic := '0';

    -- axi global signal
    m_aclk                         : in  std_logic := '0';
    s_aclk                         : in  std_logic := '0';
    s_aresetn                      : in  std_logic := '1'; -- Active low reset, default value set to 1
    m_aclk_en                      : in  std_logic := '0';
    s_aclk_en                      : in  std_logic := '0';

    -- axi full/lite slave write channel (write side)
    s_axi_awid                     : in  std_logic_vector(C_AXI_ID_WIDTH-1 downto 0) := (others => '0');
    s_axi_awaddr                   : in  std_logic_vector(C_AXI_ADDR_WIDTH-1 downto 0) := (others => '0');
    s_axi_awlen                    : in  std_logic_vector(C_AXI_LEN_WIDTH-1 downto 0) := (others => '0');
    s_axi_awsize                   : in  std_logic_vector(3-1 downto 0) := (others => '0');
    s_axi_awburst                  : in  std_logic_vector(2-1 downto 0) := (others => '0');
    s_axi_awlock                   : in  std_logic_vector(C_AXI_LOCK_WIDTH-1 downto 0) := (others => '0');
    s_axi_awcache                  : in  std_logic_vector(4-1 downto 0) := (others => '0');
    s_axi_awprot                   : in  std_logic_vector(3-1 downto 0) := (others => '0');
    s_axi_awqos                    : in  std_logic_vector(4-1 downto 0) := (others => '0');
    s_axi_awregion                 : in  std_logic_vector(4-1 downto 0) := (others => '0');
    s_axi_awuser                   : in  std_logic_vector(C_AXI_AWUSER_WIDTH-1 downto 0) := (others => '0');
    s_axi_awvalid                  : in  std_logic := '0';
    s_axi_awready                  : out std_logic := '0';
    s_axi_wid                      : in  std_logic_vector(C_AXI_ID_WIDTH-1 downto 0)     := (others => '0');
    s_axi_wdata                    : in  std_logic_vector(C_AXI_DATA_WIDTH-1 downto 0)   := (others => '0');
    s_axi_wstrb                    : in  std_logic_vector(C_AXI_DATA_WIDTH/8-1 downto 0) := (others => '0');
    s_axi_wlast                    : in  std_logic := '0';
    s_axi_wuser                    : in  std_logic_vector(C_AXI_WUSER_WIDTH-1 downto 0)  := (others => '0');
    s_axi_wvalid                   : in  std_logic := '0';
    s_axi_wready                   : out std_logic := '0';
    s_axi_bid                      : out std_logic_vector(C_AXI_ID_WIDTH-1 downto 0)     := (others => '0');
    s_axi_bresp                    : out std_logic_vector(2-1 downto 0)                  := (others => '0');
    s_axi_buser                    : out std_logic_vector(C_AXI_BUSER_WIDTH-1 downto 0)  := (others => '0');
    s_axi_bvalid                   : out std_logic := '0';
    s_axi_bready                   : in  std_logic := '0';

    -- axi full/lite master write channel (read side)
    m_axi_awid                     : out std_logic_vector(C_AXI_ID_WIDTH-1 downto 0)   := (others => '0');
    m_axi_awaddr                   : out std_logic_vector(C_AXI_ADDR_WIDTH-1 downto 0) := (others => '0');
    m_axi_awlen                    : out std_logic_vector(C_AXI_LEN_WIDTH-1 downto 0) := (others => '0');
    m_axi_awsize                   : out std_logic_vector(3-1 downto 0) := (others => '0');
    m_axi_awburst                  : out std_logic_vector(2-1 downto 0) := (others => '0');
    m_axi_awlock                   : out std_logic_vector(C_AXI_LOCK_WIDTH-1 downto 0) := (others => '0');
    m_axi_awcache                  : out std_logic_vector(4-1 downto 0) := (others => '0');
    m_axi_awprot                   : out std_logic_vector(3-1 downto 0) := (others => '0');
    m_axi_awqos                    : out std_logic_vector(4-1 downto 0) := (others => '0');
    m_axi_awregion                 : out std_logic_vector(4-1 downto 0) := (others => '0');
    m_axi_awuser                   : out std_logic_vector(C_AXI_AWUSER_WIDTH-1 downto 0) := (others => '0');
    m_axi_awvalid                  : out std_logic := '0';
    m_axi_awready                  : in  std_logic := '0';
    m_axi_wid                      : out std_logic_vector(C_AXI_ID_WIDTH-1 downto 0)     := (others => '0');
    m_axi_wdata                    : out std_logic_vector(C_AXI_DATA_WIDTH-1 downto 0)   := (others => '0');
    m_axi_wstrb                    : out std_logic_vector(C_AXI_DATA_WIDTH/8-1 downto 0) := (others => '0');
    m_axi_wlast                    : out std_logic := '0';
    m_axi_wuser                    : out std_logic_vector(C_AXI_WUSER_WIDTH-1 downto 0)  := (others => '0');
    m_axi_wvalid                   : out std_logic := '0';
    m_axi_wready                   : in  std_logic := '0';
    m_axi_bid                      : in  std_logic_vector(C_AXI_ID_WIDTH-1 downto 0)    := (others => '0');
    m_axi_bresp                    : in  std_logic_vector(2-1 downto 0)                 := (others => '0');
    m_axi_buser                    : in  std_logic_vector(C_AXI_BUSER_WIDTH-1 downto 0) := (others => '0');
    m_axi_bvalid                   : in  std_logic := '0';
    m_axi_bready                   : out std_logic := '0';

    -- axi full/lite slave read channel (write side)
    s_axi_arid                     : in  std_logic_vector(C_AXI_ID_WIDTH-1 downto 0)   := (others => '0');
    s_axi_araddr                   : in  std_logic_vector(C_AXI_ADDR_WIDTH-1 downto 0) := (others => '0'); 
    s_axi_arlen                    : in  std_logic_vector(C_AXI_LEN_WIDTH-1 downto 0) := (others => '0');
    s_axi_arsize                   : in  std_logic_vector(3-1 downto 0) := (others => '0');
    s_axi_arburst                  : in  std_logic_vector(2-1 downto 0) := (others => '0');
    s_axi_arlock                   : in  std_logic_vector(C_AXI_LOCK_WIDTH-1 downto 0) := (others => '0');
    s_axi_arcache                  : in  std_logic_vector(4-1 downto 0) := (others => '0');
    s_axi_arprot                   : in  std_logic_vector(3-1 downto 0) := (others => '0');
    s_axi_arqos                    : in  std_logic_vector(4-1 downto 0) := (others => '0');
    s_axi_arregion                 : in  std_logic_vector(4-1 downto 0) := (others => '0');
    s_axi_aruser                   : in  std_logic_vector(C_AXI_ARUSER_WIDTH-1 downto 0) := (others => '0');
    s_axi_arvalid                  : in  std_logic := '0';
    s_axi_arready                  : out std_logic := '0';
    s_axi_rid                      : out std_logic_vector(C_AXI_ID_WIDTH-1 downto 0)   := (others => '0');       
    s_axi_rdata                    : out std_logic_vector(C_AXI_DATA_WIDTH-1 downto 0) := (others => '0'); 
    s_axi_rresp                    : out std_logic_vector(2-1 downto 0)                := (others => '0');
    s_axi_rlast                    : out std_logic := '0';
    s_axi_ruser                    : out std_logic_vector(C_AXI_RUSER_WIDTH-1 downto 0) := (others => '0');
    s_axi_rvalid                   : out std_logic := '0';
    s_axi_rready                   : in  std_logic := '0';

    -- axi full/lite master read channel (read side)
    m_axi_arid                     : out std_logic_vector(C_AXI_ID_WIDTH-1 downto 0)   := (others => '0');        
    m_axi_araddr                   : out std_logic_vector(C_AXI_ADDR_WIDTH-1 downto 0) := (others => '0');  
    m_axi_arlen                    : out std_logic_vector(C_AXI_LEN_WIDTH-1 downto 0) := (others => '0');
    m_axi_arsize                   : out std_logic_vector(3-1 downto 0) := (others => '0');
    m_axi_arburst                  : out std_logic_vector(2-1 downto 0) := (others => '0');
    m_axi_arlock                   : out std_logic_vector(C_AXI_LOCK_WIDTH-1 downto 0) := (others => '0');
    m_axi_arcache                  : out std_logic_vector(4-1 downto 0) := (others => '0');
    m_axi_arprot                   : out std_logic_vector(3-1 downto 0) := (others => '0');
    m_axi_arqos                    : out std_logic_vector(4-1 downto 0) := (others => '0');
    m_axi_arregion                 : out std_logic_vector(4-1 downto 0) := (others => '0');
    m_axi_aruser                   : out std_logic_vector(C_AXI_ARUSER_WIDTH-1 downto 0) := (others => '0');
    m_axi_arvalid                  : out std_logic := '0';
    m_axi_arready                  : in  std_logic := '0';
    m_axi_rid                      : in  std_logic_vector(C_AXI_ID_WIDTH-1 downto 0) := (others => '0');        
    m_axi_rdata                    : in  std_logic_vector(C_AXI_DATA_WIDTH-1 downto 0) := (others => '0');  
    m_axi_rresp                    : in  std_logic_vector(2-1 downto 0) := (others => '0');
    m_axi_rlast                    : in  std_logic := '0';
    m_axi_ruser                    : in  std_logic_vector(C_AXI_RUSER_WIDTH-1 downto 0) := (others => '0');
    m_axi_rvalid                   : in  std_logic := '0';
    m_axi_rready                   : out std_logic := '0';

    -- axi streaming slave signals (write side)
    s_axis_tvalid                  : in  std_logic := '0';
    s_axis_tready                  : out std_logic := '0';
    s_axis_tdata                   : in  std_logic_vector(C_AXIS_TDATA_WIDTH-1 downto 0) := (others => '0');
    s_axis_tstrb                   : in  std_logic_vector(C_AXIS_TSTRB_WIDTH-1 downto 0) := (others => '0');
    s_axis_tkeep                   : in  std_logic_vector(C_AXIS_TKEEP_WIDTH-1 downto 0) := (others => '0');
    s_axis_tlast                   : in  std_logic := '0';
    s_axis_tid                     : in  std_logic_vector(C_AXIS_TID_WIDTH-1 downto 0) := (others => '0');
    s_axis_tdest                   : in  std_logic_vector(C_AXIS_TDEST_WIDTH-1 downto 0) := (others => '0');
    s_axis_tuser                   : in  std_logic_vector(C_AXIS_TUSER_WIDTH-1 downto 0) := (others => '0');

    -- axi streaming master signals (read side)
    m_axis_tvalid                  : out std_logic := '0';
    m_axis_tready                  : in  std_logic := '0';
    m_axis_tdata                   : out std_logic_vector(C_AXIS_TDATA_WIDTH-1 downto 0) := (others => '0');
    m_axis_tstrb                   : out std_logic_vector(C_AXIS_TSTRB_WIDTH-1 downto 0) := (others => '0');
    m_axis_tkeep                   : out std_logic_vector(C_AXIS_TKEEP_WIDTH-1 downto 0) := (others => '0');
    m_axis_tlast                   : out std_logic := '0';
    m_axis_tid                     : out std_logic_vector(C_AXIS_TID_WIDTH-1 downto 0) := (others => '0');
    m_axis_tdest                   : out std_logic_vector(C_AXIS_TDEST_WIDTH-1 downto 0) := (others => '0');
    m_axis_tuser                   : out std_logic_vector(C_AXIS_TUSER_WIDTH-1 downto 0) := (others => '0');

    -- axi full/lite write address channel signals
    axi_aw_injectsbiterr           : in  std_logic := '0';
    axi_aw_injectdbiterr           : in  std_logic := '0';
    axi_aw_prog_full_thresh        : in  std_logic_vector(C_WR_PNTR_WIDTH_WACH-1 downto 0) := (others => '0');
    axi_aw_prog_empty_thresh       : in  std_logic_vector(C_WR_PNTR_WIDTH_WACH-1 downto 0) := (others => '0');
    axi_aw_data_count              : out std_logic_vector(C_WR_PNTR_WIDTH_WACH downto 0) := (others => '0');
    axi_aw_wr_data_count           : out std_logic_vector(C_WR_PNTR_WIDTH_WACH downto 0) := (others => '0');
    axi_aw_rd_data_count           : out std_logic_vector(C_WR_PNTR_WIDTH_WACH downto 0) := (others => '0');
    axi_aw_sbiterr                 : out std_logic := '0';
    axi_aw_dbiterr                 : out std_logic := '0';
    axi_aw_overflow                : out std_logic := '0';
    axi_aw_underflow               : out std_logic := '0';
    axi_aw_prog_full               : out std_logic := '0';
    axi_aw_prog_empty              : out std_logic := '1';
--    axi_aw_almost_full             : out std_logic := '0';
--    axi_aw_almost_empty            : out std_logic := '1';

    -- axi full/lite write data channel signals
    axi_w_injectsbiterr            : in  std_logic := '0';
    axi_w_injectdbiterr            : in  std_logic := '0';
    axi_w_prog_full_thresh         : in  std_logic_vector(C_WR_PNTR_WIDTH_WDCH-1 downto 0) := (others => '0');
    axi_w_prog_empty_thresh        : in  std_logic_vector(C_WR_PNTR_WIDTH_WDCH-1 downto 0) := (others => '0');
    axi_w_data_count               : out std_logic_vector(C_WR_PNTR_WIDTH_WDCH downto 0) := (others => '0');
    axi_w_wr_data_count            : out std_logic_vector(C_WR_PNTR_WIDTH_WDCH downto 0) := (others => '0');
    axi_w_rd_data_count            : out std_logic_vector(C_WR_PNTR_WIDTH_WDCH downto 0) := (others => '0');
    axi_w_sbiterr                  : out std_logic := '0';
    axi_w_dbiterr                  : out std_logic := '0';
    axi_w_overflow                 : out std_logic := '0';
    axi_w_underflow                : out std_logic := '0';
    axi_w_prog_full                : out std_logic := '0';
    axi_w_prog_empty               : out std_logic := '1';
 --   axi_w_almost_full              : out std_logic := '0';
 --   axi_w_almost_empty             : out std_logic := '1';

    -- axi full/lite write response channel signals
    axi_b_injectsbiterr            : in  std_logic := '0';
    axi_b_injectdbiterr            : in  std_logic := '0';
    axi_b_prog_full_thresh         : in  std_logic_vector(C_WR_PNTR_WIDTH_WRCH-1 downto 0) := (others => '0');
    axi_b_prog_empty_thresh        : in  std_logic_vector(C_WR_PNTR_WIDTH_WRCH-1 downto 0) := (others => '0');
    axi_b_data_count               : out std_logic_vector(C_WR_PNTR_WIDTH_WRCH downto 0) := (others => '0');
    axi_b_wr_data_count            : out std_logic_vector(C_WR_PNTR_WIDTH_WRCH downto 0) := (others => '0');
    axi_b_rd_data_count            : out std_logic_vector(C_WR_PNTR_WIDTH_WRCH downto 0) := (others => '0');
    axi_b_sbiterr                  : out std_logic := '0';
    axi_b_dbiterr                  : out std_logic := '0';
    axi_b_overflow                 : out std_logic := '0';
    axi_b_underflow                : out std_logic := '0';
    axi_b_prog_full                : out std_logic := '0';
    axi_b_prog_empty               : out std_logic := '1';
 --   axi_b_almost_full              : out std_logic := '0';
 --   axi_b_almost_empty             : out std_logic := '1';

    -- axi full/lite read address channel signals
    axi_ar_injectsbiterr           : in  std_logic := '0';
    axi_ar_injectdbiterr           : in  std_logic := '0';
    axi_ar_prog_full_thresh        : in  std_logic_vector(C_WR_PNTR_WIDTH_RACH-1 downto 0) := (others => '0');
    axi_ar_prog_empty_thresh       : in  std_logic_vector(C_WR_PNTR_WIDTH_RACH-1 downto 0) := (others => '0');
    axi_ar_data_count              : out std_logic_vector(C_WR_PNTR_WIDTH_RACH downto 0) := (others => '0');
    axi_ar_wr_data_count           : out std_logic_vector(C_WR_PNTR_WIDTH_RACH downto 0) := (others => '0');
    axi_ar_rd_data_count           : out std_logic_vector(C_WR_PNTR_WIDTH_RACH downto 0) := (others => '0');
    axi_ar_sbiterr                 : out std_logic := '0';
    axi_ar_dbiterr                 : out std_logic := '0';
    axi_ar_overflow                : out std_logic := '0';
    axi_ar_underflow               : out std_logic := '0';
    axi_ar_prog_full               : out std_logic := '0';
    axi_ar_prog_empty              : out std_logic := '1';
 --   axi_ar_almost_full             : out std_logic := '0';
 --   axi_ar_almost_empty            : out std_logic := '1';

    -- axi full/lite read data channel signals
    axi_r_injectsbiterr            : in  std_logic := '0';
    axi_r_injectdbiterr            : in  std_logic := '0';
    axi_r_prog_full_thresh         : in  std_logic_vector(C_WR_PNTR_WIDTH_RDCH-1 downto 0) := (others => '0');
    axi_r_prog_empty_thresh        : in  std_logic_vector(C_WR_PNTR_WIDTH_RDCH-1 downto 0) := (others => '0');
    axi_r_data_count               : out std_logic_vector(C_WR_PNTR_WIDTH_RDCH downto 0) := (others => '0');
    axi_r_wr_data_count            : out std_logic_vector(C_WR_PNTR_WIDTH_RDCH downto 0) := (others => '0');
    axi_r_rd_data_count            : out std_logic_vector(C_WR_PNTR_WIDTH_RDCH downto 0) := (others => '0');
    axi_r_sbiterr                  : out std_logic := '0';
    axi_r_dbiterr                  : out std_logic := '0';
    axi_r_overflow                 : out std_logic := '0';
    axi_r_underflow                : out std_logic := '0';
    axi_r_prog_full                : out std_logic := '0';
    axi_r_prog_empty               : out std_logic := '1';
 --   axi_r_almost_full              : out std_logic := '0';
 --   axi_r_almost_empty             : out std_logic := '1';

    -- axi streaming fifo related signals
    axis_injectsbiterr             : in  std_logic := '0';
    axis_injectdbiterr             : in  std_logic := '0';
    axis_prog_full_thresh          : in  std_logic_vector(C_WR_PNTR_WIDTH_AXIS-1 downto 0) := (others => '0');
    axis_prog_empty_thresh         : in  std_logic_vector(C_WR_PNTR_WIDTH_AXIS-1 downto 0) := (others => '0');
    axis_data_count                : out std_logic_vector(C_WR_PNTR_WIDTH_AXIS downto 0) := (others => '0');
    axis_wr_data_count             : out std_logic_vector(C_WR_PNTR_WIDTH_AXIS downto 0) := (others => '0');
    axis_rd_data_count             : out std_logic_vector(C_WR_PNTR_WIDTH_AXIS downto 0) := (others => '0');
    axis_sbiterr                   : out std_logic := '0';
    axis_dbiterr                   : out std_logic := '0';
    axis_overflow                  : out std_logic := '0';
    axis_underflow                 : out std_logic := '0';
    axis_prog_full                 : out std_logic := '0';
    axis_prog_empty                : out std_logic := '1'
 --   axis_almost_full               : out std_logic := '0';
 --   axis_almost_empty              : out std_logic := '1'

    );
END COMPONENT;

-- End FIFO Generator Component ---------------------------------------
   
   
   
   
   
-------------------------------------------------------------------------------------
-- Start Block Memory Generator Component for blk_mem_gen_v8_1
-- Component declaration for blk_mem_gen_v8_1 pulled from the 
-- /proj/xbuilds/ids_14.4_P.49d.2.0/lin64/14.4/ISE_DS/ISE/vhdl/src/XilinxCoreLib
-- file: blk_mem_gen_v8_1.v
-- Verilog file used to match paramter order for NCSIM compatibility
-------------------------------------------------------------------------------------

component blk_mem_gen_v8_1 IS
GENERIC (
  C_FAMILY                  : STRING  := "virtex6";
  C_XDEVICEFAMILY           : STRING  := "virtex6";
  C_ELABORATION_DIR         : STRING  := "";
  C_INTERFACE_TYPE          : INTEGER := 0;
  C_USE_BRAM_BLOCK          : INTEGER := 0;
  C_ENABLE_32BIT_ADDRESS    : INTEGER := 0;
  C_AXI_TYPE                : INTEGER := 0;
  C_AXI_SLAVE_TYPE          : INTEGER := 0;
  C_HAS_AXI_ID              : INTEGER := 0;
  C_AXI_ID_WIDTH            : INTEGER := 4;
  C_MEM_TYPE                : INTEGER := 2;
  C_BYTE_SIZE               : INTEGER := 8;
  C_ALGORITHM               : INTEGER := 2;
  C_PRIM_TYPE               : INTEGER := 3;
  C_LOAD_INIT_FILE          : INTEGER := 0;
  C_INIT_FILE_NAME          : STRING  := "";
  C_INIT_FILE               : STRING  := "";
  C_USE_DEFAULT_DATA        : INTEGER := 0;
  C_DEFAULT_DATA            : STRING  := "";
  C_RST_TYPE                : STRING  := "SYNC";
  C_HAS_RSTA                : INTEGER := 0;
  C_RST_PRIORITY_A          : STRING  := "CE";
  C_RSTRAM_A                : INTEGER := 0;
  C_INITA_VAL               : STRING  := "";
  C_HAS_ENA                 : INTEGER := 1;
  C_HAS_REGCEA              : INTEGER := 0;
  C_USE_BYTE_WEA            : INTEGER := 0;
  C_WEA_WIDTH               : INTEGER := 1;
  C_WRITE_MODE_A            : STRING  := "WRITE_FIRST";
  C_WRITE_WIDTH_A           : INTEGER := 32;
  C_READ_WIDTH_A            : INTEGER := 32;
  C_WRITE_DEPTH_A           : INTEGER := 64;
  C_READ_DEPTH_A            : INTEGER := 64;
  C_ADDRA_WIDTH             : INTEGER := 6;
  C_HAS_RSTB                : INTEGER := 0;
  C_RST_PRIORITY_B          : STRING  := "CE";
  C_RSTRAM_B                : INTEGER := 0;
  C_INITB_VAL               : STRING  := "";
  C_HAS_ENB                 : INTEGER := 1;
  C_HAS_REGCEB              : INTEGER := 0;
  C_USE_BYTE_WEB            : INTEGER := 0;
  C_WEB_WIDTH               : INTEGER := 1;
  C_WRITE_MODE_B            : STRING  := "WRITE_FIRST";
  C_WRITE_WIDTH_B           : INTEGER := 32;
  C_READ_WIDTH_B            : INTEGER := 32;
  C_WRITE_DEPTH_B           : INTEGER := 64;
  C_READ_DEPTH_B            : INTEGER := 64;
  C_ADDRB_WIDTH             : INTEGER := 6;
  C_HAS_MEM_OUTPUT_REGS_A   : INTEGER := 0;
  C_HAS_MEM_OUTPUT_REGS_B   : INTEGER := 0;
  C_HAS_MUX_OUTPUT_REGS_A   : INTEGER := 0;
  C_HAS_MUX_OUTPUT_REGS_B   : INTEGER := 0;
  C_HAS_SOFTECC_INPUT_REGS_A  : INTEGER := 0;
  C_HAS_SOFTECC_OUTPUT_REGS_B : INTEGER := 0;
  C_MUX_PIPELINE_STAGES     : INTEGER := 0;
  C_USE_SOFTECC             : INTEGER := 0;
  C_USE_ECC                 : INTEGER := 0;
  C_HAS_INJECTERR           : INTEGER := 0;
  C_SIM_COLLISION_CHECK     : STRING  := "NONE";
  C_COMMON_CLK              : INTEGER := 1;
  C_DISABLE_WARN_BHV_COLL   : INTEGER := 0;
  C_DISABLE_WARN_BHV_RANGE  : INTEGER := 0
);
PORT (
  CLKA          : IN  STD_LOGIC := '0';
  RSTA          : IN  STD_LOGIC := '0';
  ENA           : IN  STD_LOGIC := '1';
  REGCEA        : IN  STD_LOGIC := '1';
  WEA           : IN  STD_LOGIC_VECTOR(C_WEA_WIDTH-1 DOWNTO 0)
                      := (OTHERS => '0');
  ADDRA         : IN  STD_LOGIC_VECTOR(C_ADDRA_WIDTH-1 DOWNTO 0):= (OTHERS => '0');
  DINA          : IN  STD_LOGIC_VECTOR(C_WRITE_WIDTH_A-1 DOWNTO 0)
                      := (OTHERS => '0');
  DOUTA         : OUT STD_LOGIC_VECTOR(C_READ_WIDTH_A-1 DOWNTO 0);
  CLKB          : IN  STD_LOGIC := '0';
  RSTB          : IN  STD_LOGIC := '0';
  ENB           : IN  STD_LOGIC := '1';
  REGCEB        : IN  STD_LOGIC := '1';
  WEB           : IN  STD_LOGIC_VECTOR(C_WEB_WIDTH-1 DOWNTO 0)
                      := (OTHERS => '0');
  ADDRB         : IN  STD_LOGIC_VECTOR(C_ADDRB_WIDTH-1 DOWNTO 0)
                      := (OTHERS => '0');
  DINB          : IN  STD_LOGIC_VECTOR(C_WRITE_WIDTH_B-1 DOWNTO 0)
                      := (OTHERS => '0');
  DOUTB         : OUT STD_LOGIC_VECTOR(C_READ_WIDTH_B-1 DOWNTO 0);
  INJECTSBITERR : IN STD_LOGIC := '0';
  INJECTDBITERR : IN STD_LOGIC := '0';
  SBITERR       : OUT STD_LOGIC := '0';
  DBITERR       : OUT STD_LOGIC := '0';
  RDADDRECC     : OUT STD_LOGIC_VECTOR(C_ADDRB_WIDTH-1 DOWNTO 0);
  -- AXI BMG Input and Output Port Declarations

    -- AXI Global Signals
  S_AClk                         : IN  STD_LOGIC := '0';
  S_ARESETN                      : IN  STD_LOGIC := '0'; 

  -- AXI Full/Lite Slave Write (write side)
  S_AXI_AWID                     : IN  STD_LOGIC_VECTOR(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
  S_AXI_AWADDR                   : IN  STD_LOGIC_VECTOR(31 DOWNTO 0) := (OTHERS => '0');
  S_AXI_AWLEN                    : IN  STD_LOGIC_VECTOR(7 DOWNTO 0) := (OTHERS => '0');
  S_AXI_AWSIZE                   : IN  STD_LOGIC_VECTOR(2 DOWNTO 0) := (OTHERS => '0');
  S_AXI_AWBURST                  : IN  STD_LOGIC_VECTOR(1 DOWNTO 0) := (OTHERS => '0');
  S_AXI_AWVALID                  : IN  STD_LOGIC := '0';
  S_AXI_AWREADY                  : OUT STD_LOGIC;
  S_AXI_WDATA                    : IN  STD_LOGIC_VECTOR(C_WRITE_WIDTH_A-1 DOWNTO 0) := (OTHERS => '0');
  S_AXI_WSTRB                    : IN  STD_LOGIC_VECTOR(C_WEA_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
  S_AXI_WLAST                    : IN  STD_LOGIC := '0';
  S_AXI_WVALID                   : IN  STD_LOGIC := '0';
  S_AXI_WREADY                   : OUT STD_LOGIC;
  S_AXI_BID                      : OUT  STD_LOGIC_VECTOR(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
  S_AXI_BRESP                    : OUT STD_LOGIC_VECTOR(1 DOWNTO 0);
  S_AXI_BVALID                   : OUT STD_LOGIC;
  S_AXI_BREADY                   : IN  STD_LOGIC := '0';

  -- AXI Full/Lite Slave Read (Write side)
  S_AXI_ARID                     : IN  STD_LOGIC_VECTOR(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
  S_AXI_ARADDR                   : IN  STD_LOGIC_VECTOR(31 DOWNTO 0) := (OTHERS => '0');
  S_AXI_ARLEN                    : IN  STD_LOGIC_VECTOR(8-1 DOWNTO 0) := (OTHERS => '0');
  S_AXI_ARSIZE                   : IN  STD_LOGIC_VECTOR(2 DOWNTO 0) := (OTHERS => '0');
  S_AXI_ARBURST                  : IN  STD_LOGIC_VECTOR(1 DOWNTO 0) := (OTHERS => '0');
  S_AXI_ARVALID                  : IN  STD_LOGIC := '0';
  S_AXI_ARREADY                  : OUT STD_LOGIC;
  S_AXI_RID                      : OUT  STD_LOGIC_VECTOR(C_AXI_ID_WIDTH-1 DOWNTO 0) := (OTHERS => '0');
  S_AXI_RDATA                    : OUT STD_LOGIC_VECTOR(C_WRITE_WIDTH_B-1 DOWNTO 0); 
  S_AXI_RRESP                    : OUT STD_LOGIC_VECTOR(2-1 DOWNTO 0);
  S_AXI_RLAST                    : OUT STD_LOGIC;
  S_AXI_RVALID                   : OUT STD_LOGIC;
  S_AXI_RREADY                   : IN  STD_LOGIC := '0';

  -- AXI Full/Lite Sideband Signals
  S_AXI_INJECTSBITERR              : IN  STD_LOGIC := '0';
  S_AXI_INJECTDBITERR              : IN  STD_LOGIC := '0';
  S_AXI_SBITERR                    : OUT STD_LOGIC := '0';
  S_AXI_DBITERR                    : OUT STD_LOGIC := '0';
  S_AXI_RDADDRECC                  : OUT STD_LOGIC_VECTOR(C_ADDRB_WIDTH-1 DOWNTO 0) := (OTHERS => '0')

);
END COMPONENT; --blk_mem_gen_v8_1

-- The following tells XST that blk_mem_gen_v8_1 is a black box which  
  -- should be generated command given by the value of this attribute 
  -- Note the fully qualified SIM (JAVA class) name that forms the 
  -- basis of the core

--  ATTRIBUTE box_type OF blk_mem_gen_v8_1 : COMPONENT IS "black_box";
--  ATTRIBUTE generator_default OF blk_mem_gen_v8_1 : COMPONENT IS
--    "generatecore com.xilinx.ip.blk_mem_gen_v8_1.blk_mem_gen_v8_1 -a map_qvirtex_to=virtex map_qrvirtex_to=virtex map_virtexe_to=virtex map_qvirtex2_to=virtex2 map_qrvirtex2_to=virtex2 map_spartan2_to=virtex map_spartan2e_to=virtex map_virtex5_to=virtex4 map_spartan3a_to=spartan3e spartan3an_to=spartan3e spartan3adsp_to=spartan3e ";
-- End Block Memory Generator Component for v7_1 -------------------------------


END coregen_comp_defs;
