# ----------------------------------------------------------------------------
#
#        ** **        **          **  ****      **  **********  ********** ®
#       **   **        **        **   ** **     **  **              **
#      **     **        **      **    **  **    **  **              **
#     **       **        **    **     **   **   **  *********       **
#    **         **        **  **      **    **  **  **              **
#   **           **        ****       **     ** **  **              **
#  **  .........  **        **        **      ****  **********      **
#     ...........
#                                     Reach Further™
#
# ----------------------------------------------------------------------------
#
#  This design is the property of Avnet.  Publication of this
#  design is not authorized without written consent from Avnet.
#
#  Please direct any questions to the Avnet Technical Community:
#     http://community.avnet.com/
#
#  Product information is available at:
#     http://www.avnet.com
#
#  Disclaimer:
#     Avnet, Inc. makes no warranty for the use of this code or design.
#     This code is provided  "As Is". Avnet, Inc assumes no responsibility for
#     any errors, which may appear in this code, nor does it make a commitment
#     to update the information contained herein. Avnet, Inc specifically
#     disclaims any implied warranties of fitness for a particular purpose.
#                      Copyright(c) 2017 Avnet, Inc.
#                              All rights reserved.
#
# ----------------------------------------------------------------------------
#
#  Create Date:         Oct 05, 2017
#  Design Name:         TSN with UltraZed and ISMNET3
#  Module Name:         UltraZed_EG_PCIe_CC_ISMNET3_Master_XDC_File_v1.xdc
#  Project Name:        UltraZed TSN Project
#  Target Devices:      Xilinx Zynq Ultrascale+ 3EG
#  Hardware Boards:     UltraZed-EG SOM, PCIe Carrier, FMC ISMNET3
#
#  Tool versions:       Xilinx Vivado 2017.2
#
#  Description:         Constraints for UltraZed + ISMNET3
#
#  Dependencies:
#
#  Revision:            Oct 05, 2017: 1.00 Initial version
#
# ----------------------------------------------------------------------------


# FMC LPC Interface - FMC ISMNET3
#
set_property IOSTANDARD LVCMOS18 [get_ports {Phy_reset_n[0]}]
set_property IOSTANDARD LVCMOS18 [get_ports {Phy_reset_n[1]}]
set_property PACKAGE_PIN M5 [get_ports {Phy_reset_n[0]}];  		# JX1_HP_DP_38_N - FMC_LA05_N
set_property PACKAGE_PIN W7 [get_ports {Phy_reset_n[1]}];  		# JX1_HP_DP_23_N - FMC_LA15_N
set_property IOSTANDARD LVCMOS18 [get_ports {reset_port_0[0]}]
set_property IOSTANDARD LVCMOS18 [get_ports {reset_port_1[0]}]
set_property PACKAGE_PIN M5 [get_ports {reset_port_0[0]}]
set_property PACKAGE_PIN W7 [get_ports {reset_port_1[0]}]

set_property PACKAGE_PIN P4 [get_ports {ref_clk_p[0]}]
set_property PACKAGE_PIN R4 [get_ports {ref_clk_n[0]}]
set_property PACKAGE_PIN L3 [get_ports rgmii_port_0_rx_ctl]
set_property PACKAGE_PIN M3 [get_ports rgmii_port_0_rxc]
set_property PACKAGE_PIN N3 [get_ports rgmii_port_2_rx_ctl]
set_property PACKAGE_PIN N4 [get_ports rgmii_port_2_rxc]
set_property PACKAGE_PIN K2 [get_ports {rgmii_port_0_rd[1]}]
set_property PACKAGE_PIN L2 [get_ports {rgmii_port_0_rd[0]}]
set_property PACKAGE_PIN R1 [get_ports {rgmii_port_0_rd[3]}]
set_property PACKAGE_PIN R2 [get_ports {rgmii_port_0_rd[2]}]
set_property PACKAGE_PIN K5 [get_ports rgmii_port_0_txc]
set_property PACKAGE_PIN K6 [get_ports {rgmii_port_0_td[0]}]
set_property PACKAGE_PIN M5 [get_ports {reset_n[0]}];  		# JX1_HP_DP_38_N - FMC_LA05_N
set_property PACKAGE_PIN N5 [get_ports mdio_io_port_0_mdc]
set_property PACKAGE_PIN L5 [get_ports mdio_io_port_0_mdio_io]
set_property PACKAGE_PIN M6 [get_ports {rgmii_port_2_rd[0]}]
set_property PACKAGE_PIN V1 [get_ports rgmii_port_0_tx_ctl]
set_property PACKAGE_PIN U1 [get_ports {rgmii_port_0_td[3]}]
set_property PACKAGE_PIN J4 [get_ports {rgmii_port_0_td[2]}]
set_property PACKAGE_PIN K4 [get_ports {rgmii_port_0_td[1]}]
set_property PACKAGE_PIN J6 [get_ports {rgmii_port_2_rd[3]}]
set_property PACKAGE_PIN J7 [get_ports {rgmii_port_2_rd[1]}]
set_property PACKAGE_PIN K7 [get_ports {rgmii_port_2_rd[2]}]
set_property PACKAGE_PIN U2 [get_ports rgmii_port_2_txc]
set_property PACKAGE_PIN T3 [get_ports {rgmii_port_2_td[1]}]
set_property PACKAGE_PIN V3 [get_ports {rgmii_port_2_td[0]}]
set_property PACKAGE_PIN P1 [get_ports mdio_io_port_2_mdc]
set_property PACKAGE_PIN N1 [get_ports {ref_clk_oe[0]}]
set_property PACKAGE_PIN P2 [get_ports mdio_io_port_2_mdio_io]
set_property PACKAGE_PIN P3 [get_ports {ref_clk_fsel[0]}]
set_property PACKAGE_PIN W7 [get_ports {reset_n[1]}];  		# JX1_HP_DP_23_N - FMC_LA15_N
set_property PACKAGE_PIN W8 [get_ports rgmii_port_2_tx_ctl]
set_property PACKAGE_PIN T7 [get_ports {rgmii_port_2_td[3]}]
set_property PACKAGE_PIN R7 [get_ports {rgmii_port_2_td[2]}]
set_property PACKAGE_PIN AD7 [get_ports {LED4B}];  			# JX1_HP_DP_07_N - FMC_LA24_N
set_property PACKAGE_PIN AD8 [get_ports {LED4A}];  			# JX1_HP_DP_07_P - FMC_LA24_P
set_property PACKAGE_PIN Y1 [get_ports {LED3B}];  			# JX1_HP_DP_09_N - FMC_LA25_N
set_property PACKAGE_PIN W1 [get_ports {LED3A}];  			# JX1_HP_DP_09_P - FMC_LA25_P
set_property PACKAGE_PIN W2 [get_ports {LED2B}];  			# JX1_HP_DP_12_N - FMC_LA26_N
set_property PACKAGE_PIN W3 [get_ports {LED2A}];  			# JX1_HP_DP_12_P - FMC_LA26_P
set_property PACKAGE_PIN AA2 [get_ports {LED1B}];  			# JX1_HP_DP_14_N - FMC_LA27_N
set_property PACKAGE_PIN Y2 [get_ports {LED1A}];  			# JX1_HP_DP_14_P - FMC_LA27_P
set_property PACKAGE_PIN AA3 [get_ports {LED5B}];  			# JX1_HP_DP_08_N - FMC_LA28_N
set_property PACKAGE_PIN AA4 [get_ports {LED5A}];  			# JX1_HP_DP_08_P - FMC_LA28_P
set_property PACKAGE_PIN B10  [get_ports {FMC_SDA}];  		# JX2_HD_SE_01_N - FMC_SDA
set_property PACKAGE_PIN C10  [get_ports {FMC_SCL}];  		# JX2_HD_SE_01_P - FMC_SCL
set_property PACKAGE_PIN H9   [get_ports {FMC_PRSNT_M2C_N}];# JX2_HD_SE_00_N - FMC_PRSNT_M2C_N
set_property PACKAGE_PIN H10  [get_ports {FMC_TRST_N}];  	# JX2_HD_SE_00_P - FMC_TRST_N

set_property IOSTANDARD LVDS [get_ports {ref_clk_n[0]}]
set_property IOSTANDARD LVDS [get_ports {ref_clk_p[0]}]
set_property IOSTANDARD LVCMOS18 [get_ports rgmii_port_0_rx_ctl]
set_property IOSTANDARD LVCMOS18 [get_ports rgmii_port_0_rxc]
set_property IOSTANDARD LVCMOS18 [get_ports rgmii_port_2_rx_ctl]
set_property IOSTANDARD LVCMOS18 [get_ports rgmii_port_2_rxc]
set_property IOSTANDARD LVCMOS18 [get_ports {rgmii_port_0_rd[1]}]
set_property IOSTANDARD LVCMOS18 [get_ports {rgmii_port_0_rd[0]}]
set_property IOSTANDARD LVCMOS18 [get_ports {rgmii_port_0_rd[3]}]
set_property IOSTANDARD LVCMOS18 [get_ports {rgmii_port_0_rd[2]}]
set_property IOSTANDARD LVCMOS18 [get_ports rgmii_port_0_txc]
set_property IOSTANDARD LVCMOS18 [get_ports {rgmii_port_0_td[0]}]
set_property IOSTANDARD LVCMOS18 [get_ports {reset_n[0]}]
set_property IOSTANDARD LVCMOS18 [get_ports mdio_io_port_0_mdc]
set_property IOSTANDARD LVCMOS18 [get_ports mdio_io_port_0_mdio_io]
set_property IOSTANDARD LVCMOS18 [get_ports {rgmii_port_2_rd[0]}]
set_property IOSTANDARD LVCMOS18 [get_ports rgmii_port_0_tx_ctl]
set_property IOSTANDARD LVCMOS18 [get_ports {rgmii_port_0_td[3]}]
set_property IOSTANDARD LVCMOS18 [get_ports {rgmii_port_0_td[2]}]
set_property IOSTANDARD LVCMOS18 [get_ports {rgmii_port_0_td[1]}]
set_property IOSTANDARD LVCMOS18 [get_ports {rgmii_port_2_rd[3]}]
set_property IOSTANDARD LVCMOS18 [get_ports {rgmii_port_2_rd[1]}]
set_property IOSTANDARD LVCMOS18 [get_ports {rgmii_port_2_rd[2]}]
set_property IOSTANDARD LVCMOS18 [get_ports rgmii_port_2_txc]
set_property IOSTANDARD LVCMOS18 [get_ports {rgmii_port_2_td[1]}]
set_property IOSTANDARD LVCMOS18 [get_ports {rgmii_port_2_td[0]}]
set_property IOSTANDARD LVCMOS18 [get_ports mdio_io_port_2_mdc]
set_property IOSTANDARD LVCMOS18 [get_ports {ref_clk_oe[0]}]
set_property IOSTANDARD LVCMOS18 [get_ports mdio_io_port_2_mdio_io]
set_property IOSTANDARD LVCMOS18 [get_ports {ref_clk_fsel[0]}]
set_property IOSTANDARD LVCMOS18 [get_ports {reset_n[1]}]
set_property IOSTANDARD LVCMOS18 [get_ports rgmii_port_2_tx_ctl]
set_property IOSTANDARD LVCMOS18 [get_ports {rgmii_port_2_td[3]}]
set_property IOSTANDARD LVCMOS18 [get_ports {rgmii_port_2_td[2]}]
set_property IOSTANDARD LVCMOS18 [get_ports {LED4B}]
set_property IOSTANDARD LVCMOS18 [get_ports {LED4A}]
set_property IOSTANDARD LVCMOS18 [get_ports {LED3B}]
set_property IOSTANDARD LVCMOS18 [get_ports {LED3A}]
set_property IOSTANDARD LVCMOS18 [get_ports {LED2B}]
set_property IOSTANDARD LVCMOS18 [get_ports {LED2A}]
set_property IOSTANDARD LVCMOS18 [get_ports {LED1B}]
set_property IOSTANDARD LVCMOS18 [get_ports {LED1A}]
set_property IOSTANDARD LVCMOS18 [get_ports {LED5B}]
set_property IOSTANDARD LVCMOS18 [get_ports {LED5A}]
set_property IOSTANDARD LVCMOS33 [get_ports {FMC_SDA}]
set_property IOSTANDARD LVCMOS33 [get_ports {FMC_SCL}]
set_property IOSTANDARD LVCMOS33 [get_ports {FMC_PRSNT_M2C_N}]
set_property IOSTANDARD LVCMOS33 [get_ports {FMC_TRST_N}]


set_property PACKAGE_PIN C8 [get_ports {LED125[0]}]
set_property PACKAGE_PIN B8 [get_ports {LED300[0]}]
set_property PACKAGE_PIN A6 [get_ports clk8k_125_micro_second]
set_property IOSTANDARD LVCMOS18 [get_ports {LED300[0]}]
set_property IOSTANDARD LVCMOS18 [get_ports clk8k_125_micro_second]
set_property IOSTANDARD LVCMOS18 [get_ports {LED125[0]}]

set_property PACKAGE_PIN B12 [get_ports clk8k_125_micro_second1]
set_property IOSTANDARD LVCMOS18 [get_ports clk8k_125_micro_second1]

set_property PACKAGE_PIN F9 [get_ports ep_scheduler_gate_states[0]]
set_property PACKAGE_PIN D11 [get_ports ep_scheduler_gate_states[1]]
set_property PACKAGE_PIN G12 [get_ports ep_scheduler_gate_states[2]]
set_property IOSTANDARD LVCMOS18 [get_ports ep_scheduler_gate_states[0]]
set_property IOSTANDARD LVCMOS18 [get_ports ep_scheduler_gate_states[1]]
set_property IOSTANDARD LVCMOS18 [get_ports ep_scheduler_gate_states[2]]

set_property PACKAGE_PIN A12 [get_ports switch_egress_1_gate_states[0]]
set_property PACKAGE_PIN E9 [get_ports switch_egress_1_gate_states[1]]
set_property PACKAGE_PIN C11 [get_ports switch_egress_1_gate_states[2]]
set_property IOSTANDARD LVCMOS18 [get_ports switch_egress_1_gate_states[0]]
set_property IOSTANDARD LVCMOS18 [get_ports switch_egress_1_gate_states[1]]
set_property IOSTANDARD LVCMOS18 [get_ports switch_egress_1_gate_states[2]]

set_property PACKAGE_PIN B11 [get_ports switch_egress_2_gate_states[0]]
set_property PACKAGE_PIN E11 [get_ports switch_egress_2_gate_states[1]]
set_property PACKAGE_PIN D9 [get_ports switch_egress_2_gate_states[2]]
set_property IOSTANDARD LVCMOS18 [get_ports switch_egress_2_gate_states[0]]
set_property IOSTANDARD LVCMOS18 [get_ports switch_egress_2_gate_states[1]]
set_property IOSTANDARD LVCMOS18 [get_ports switch_egress_2_gate_states[2]]


# The following constraints force placement of the BUFGs needed by the RGMII RX clock for Ethernet FMC ports 2 and 3
# Without these constraints, timing will not close because the BUFGCE selected by Vivado is too far.
# It is actually not recommended to use LOC constraints on BUFGCEs but instead to constrain placement to a clock
# region, but in Vivado 2017.2, even this does not result a good placement of BUFGCE and timing closure.

set_property BEL BUFCE [get_cells *_i/gmii_to_rgmii_2/U0/i_gmii_to_rgmii_block/*_gmii_to_rgmii_2_0_core/i_gmii_to_rgmii/i_gmii_to_rgmii/bufg_rgmii_rx_clk]
set_property LOC BUFGCE_X0Y15 [get_cells *_i/gmii_to_rgmii_2/U0/i_gmii_to_rgmii_block/*_gmii_to_rgmii_2_0_core/i_gmii_to_rgmii/i_gmii_to_rgmii/bufg_rgmii_rx_clk]
set_property BEL BUFCE [get_cells *_i/gmii_to_rgmii_2/U0/i_gmii_to_rgmii_block/*_gmii_to_rgmii_2_0_core/i_gmii_to_rgmii/i_gmii_to_rgmii/bufio_rgmii_rx_clk]
set_property LOC BUFGCE_X0Y14 [get_cells *_i/gmii_to_rgmii_2/U0/i_gmii_to_rgmii_block/*_gmii_to_rgmii_2_0_core/i_gmii_to_rgmii/i_gmii_to_rgmii/bufio_rgmii_rx_clk]

#set_property BEL BUFCE [get_cells *_i/gmii_to_rgmii_3/U0/*_gmii_to_rgmii_3_0_core/i_gmii_to_rgmii/i_gmii_to_rgmii/bufg_rgmii_rx_clk]
#set_property LOC BUFGCE_X0Y19 [get_cells *_i/gmii_to_rgmii_3/U0/*_gmii_to_rgmii_3_0_core/i_gmii_to_rgmii/i_gmii_to_rgmii/bufg_rgmii_rx_clk]
#set_property BEL BUFCE [get_cells *_i/gmii_to_rgmii_3/U0/*_gmii_to_rgmii_3_0_core/i_gmii_to_rgmii/i_gmii_to_rgmii/bufio_rgmii_rx_clk]
#set_property LOC BUFGCE_X0Y18 [get_cells *_i/gmii_to_rgmii_3/U0/*_gmii_to_rgmii_3_0_core/i_gmii_to_rgmii/i_gmii_to_rgmii/bufio_rgmii_rx_clk]

##Interclock false path (AXI lite <-> GTX)

set_false_path -from [get_clocks clk_out4_design_1_clk_wiz_0_0] -to [get_clocks clk_out2_design_1_clk_wiz_0_0]
set_false_path -from [get_clocks clk_out2_design_1_clk_wiz_0_0] -to [get_clocks clk_out4_design_1_clk_wiz_0_0]


##Interclock false path (EP-RXFIFO <-> GTX)

set_false_path -from [get_clocks clk_out1_design_1_clk_wiz_0_0] -to [get_clocks clk_out2_design_1_clk_wiz_0_0]
set_false_path -from [get_clocks clk_out2_design_1_clk_wiz_0_0] -to [get_clocks clk_out1_design_1_clk_wiz_0_0]

#set_false_path -from [get_clocks clk_out1_design_1_clk_wiz_0_0] -to [get_clocks clk_out1_design_1_clk_wiz_0_0]


set_property IOSTANDARD LVCMOS33 [get_ports SPI1_io1_io]
set_property IOSTANDARD LVCMOS33 [get_ports SPI1_ss_io]
set_property IOSTANDARD LVCMOS33 [get_ports SPI1_io0_io]
set_property IOSTANDARD LVCMOS33 [get_ports SPI1_sck_io]
set_property PACKAGE_PIN B12 [get_ports SPI1_ss_io]
set_property PACKAGE_PIN F9 [get_ports SPI1_io0_io]
set_property PACKAGE_PIN D11 [get_ports SPI1_io1_io]
set_property PACKAGE_PIN G12 [get_ports SPI1_sck_io]
